package user_interface;
import db_context.DbContext;
import db_context.MyExceptions;
import row_data_gateway.*;
import complex_operations.*;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;

public class MainMenu extends Menu {

    @Override
    public void print() {
        System.out.println("******************************");
        System.out.println("* 1. item menu               *");
        System.out.println("* 2. package menu            *");
        System.out.println("* 3. transport menu          *");
        System.out.println("* 4. driver menu             *");
        System.out.println("* 5. complex operations menu *");
        System.out.println("* 6. exit                    *");
        System.out.println("******************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":   new MenuItem().run(); break;
                case "2":   new MenuPackage().run(); break;
                case "3":   new MenuTransport().run(); break;
                case "4":   new MenuDriver().run(); break;
                case "5":  new MenuOther().run(); break;

                case "6":  DbContext.getConnection().close(); exit(); break;
                default:   System.out.println("Unknown option"); break;
            }
        }catch(Exception e) {
            //throw new RuntimeException(e);
            System.out.println("something went wrong\nmessage: " + e.getMessage());
        }
    }
}